<?php

namespace App\Http\Controllers;

use App\Models\Rol;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\UsersRol;

class UsersRolController extends Controller
{

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallrole()
    {
        $response = Rol::where('status', 'A')->orderBy('rol_description', 'ASC')->get();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getusersrolbyuserid(Request $request)
    {
        $response = UsersRol::where('users_sid', $request->sid)->with('rol')->get();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function deleteusersrolbyid(Request $request)
    {
        $response = UsersRol::where('id', $request->id)->delete();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function saveusersrol(Request $request)
    {
        // Check if the role exists
        if(UsersRol::where('users_sid', $request->users_sid)->where('global_rol_id', $request->global_rol_id)->doesntExist())
        {
            $response = UsersRol::create(
                array(
                    'users_sid'     =>  $request->users_sid,
                    'global_rol_id' =>  $request->global_rol_id
                )
            );
            return response()->json(
                [
                    'status'    =>      'success',
                    'message'   =>      $response
                ], 200
            );
        }
        else
        {
            return response()->json(
                [
                    'status'    =>      'success',
                    'message'   =>      'Already saved'
                ], 200
            );
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function grantallbyrol(Request $request)
    {
        // Iniciamos el tiempo del calculo que nos debe tomar
        $start = microtime(true);
        // Guardamos el rol en una variable
        $rol = $request->id;
        // Obtenemos todos los usuarios
        $users = User::where('status', 'A')->orderBy('id', 'ASC')->get();
        // Recorremos todos los roles adicionados a un usuario
        foreach ($users as $data)
        {
            // Ahora tenemos el SID de cada usuario
            $sid = $data->sid;
            // Y si no existe el rol que me mandaron entonces lo debo guardar
            if(!UsersRol::where('users_sid', $sid)->where('global_rol_id', $rol)->exists())
            {
                UsersRol::create(
                    array(
                        'users_sid'     =>      $sid,
                        'global_rol_id' =>      $rol
                    )
                );
            }
        }
        // Calculamos el tiempo que nos ha tomado
        $time_elapsed_secs = microtime(true) - $start;
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      'Done!',
                'time'      =>      $time_elapsed_secs
            ], 200
        );
    }

}
