<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Ufv;

class UfvController extends Controller
{

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallufv(Request $request)
    {
        $response = Ufv::where('status', 'A')->orderBy('date_ufv', 'DESC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getufvbyid(Request $request)
    {
        $response = Ufv::where('status', 'A')->where('id', $request->id)->orderBy('date_ufv', 'DESC')->get()->first();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function register(Request $request)
    {
        $request->merge(['users_sid' => $this->getusersid()]);
        $response = Ufv::create($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request)
    {
        $request->merge(['users_sid' => $this->getusersid()]);
        $response = Ufv::where('id', $request->id)->update($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function delete(Request $request)
    {
        $response = Ufv::where('id', $request->id)->update(array('status', 'X'));
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchdata(Request $request)
    {
        $response = Ufv::where('ufv', 'like', '%'.$request->search.'%')
            ->orderBy('id', 'ASC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @return mixed
     */
    private function getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }
}
