<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\System;

class SystemController extends Controller
{

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function gethowmuchsystems()
    {
        $response = System::where('status', 'A')->whereDate('exp', '>=', date("Y-m-d"))->count();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallsystemsenabled()
    {
        $response = System::where('status', 'A')->get();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallsystembypage(Request $request)
    {
        $response = System::orderBy('id', 'ASC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallsystem(Request $request)
    {
        $response = System::orderBy('id', 'ASC')->get();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function saveallsystem(Request $request)
    {
        $users_sid = $this->getusersid();
        $request->merge(['users_sid' => $users_sid]);
        $response = System::create($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function enablesystems(Request $request)
    {
        // Recibimos los sistemas
        $systemsEnabled = $request->systems_enabled;
        // Verificamos si puede con todos
        if($systemsEnabled == "*")
        {
            $response = System::where('id', '<>', NULL)->update(array(
                'exp'       =>  $request->expiration_date,
                'status'    =>  'A'
            ));
            return response()->json(
                [
                    'status'    =>      'success',
                    'message'   =>      $response
                ], 200
            );
        }
        else
        {
            foreach (explode(",", $systemsEnabled) as $sys)
            {
                $search = trim($sys);
                $datap[] = $search;
                $response[] = System::where('id', '<>', NULL)
                    ->where('code', $search)
                    ->update(array(
                        'exp'       =>  $request->expiration_date,
                        'status'    =>  'A'
                    ));
            }
            return response()->json(
                [
                    'status'    =>      'success',
                    'message'   =>      $response,
                    'sys'       =>      $datap
                ], 200
            );
        }
    }

    /**
     * @return mixed
     */
    private function getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }

}
