<?php

namespace App\Http\Controllers;

use App\Jobs\SendEmailWithPassword;
use App\Models\UsersPasswords;
use App\Models\Person;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SendPasswordsController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallusersandpasswords(Request $request)
    {
        $response = UsersPasswords::where('status', 'A')
            ->with(
                [
                    'users' => function($q) {
                        $q->with(
                            [
                                'person'
                            ]
                        );
                    }
                ]
            )
            ->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallusersandpasswordsnp(Request $request)
    {
        $response = UsersPasswords::where('status', 'A')
            ->with(
                [
                    'users' => function($q) {
                        $q->with(
                            [
                                'person'
                            ]
                        );
                    }
                ]
            )
            ->get();
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchallusersandpasswords(Request $request)
    {
        $users_table = new User();
        $person_table = new Person();
        $response = UsersPasswords::where('status', 'A')
            ->whereIn('users_id', function($query)use($request, $users_table, $person_table){
                $query->select('sid')->from($users_table->getTableName())
                    ->whereIn('person_id', function($query)use($request, $person_table){
                        $query->select('id')->from($person_table->getTableName())->where(DB::raw("CONCAT(`first_name`, ' ', `last_name`)"), 'like', '%'.$request->search.'%')->where('status', 'A')->get();
                    })->get();
            })
            ->with(
                [
                    'users' => function($q) {
                        $q->with(
                            [
                                'person'
                            ]
                        );
                    }
                ]
            )
            ->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function sendsinglenotificationemail(Request $request)
    {
        $fullname = $request->full_name;
        $email = $request->email;
        $password = base64_decode($request->password);
        // Sending single notification email
        SendEmailWithPassword::dispatch($fullname, $email, $password);
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  'Single notification sended!'
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function sendmultiplenotificationemail(Request $request)
    {
        foreach ($request->data as $data)
        {
            // Sending single notification email
            SendEmailWithPassword::dispatch($data['full_name'], $data['email'], $data['password']);
            // Sleep
            sleep(1);
        }
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  'Single notification sended!'
            ], 200
        );
    }
}
