<?php

namespace App\Http\Controllers;

use App\Models\Rol;
use Illuminate\Http\Request;

class RolController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallrolbypage(Request $request)
    {
        $response = Rol::with(
            [
                'user','system'
            ]
        )->orderBy('global_system_id', 'ASC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getalljustrol()
    {
        $response = Rol::orderBy('global_system_id', 'ASC')->with(['system'])->get();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getrolbyid(Request $request)
    {
        $response = Rol::where('id', $request->id)->get()->first();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchdata(Request $request)
    {
        $response = Rol::where('rol_name', 'like', '%'.$request->search.'%')
            ->orWhere('rol_description', 'like', '%'.$request->search.'%')
            ->with(
            [
                'user','system'
            ]
        )->orderBy('global_system_id', 'ASC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function saveallrol(Request $request)
    {
        $users_sid = $this->getusersid();
        $request->merge(['users_sid' => $users_sid]);
        $response = Rol::create($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateallrol(Request $request)
    {
        $users_sid = $this->getusersid();
        $request->merge(['users_sid' => $users_sid]);
        $response = Rol::where('id', $request->id)->update($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function removerol(Request $request)
    {
        $response = Rol::where('id', $request->id)->delete();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @return mixed
     */
    private function getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }
}
