<?php

namespace App\Http\Controllers;

use App\Jobs\SendCodeForRecoverAccount;
use App\Models\Person;
use App\Models\User;
use App\Models\UsersPasswords;
use Illuminate\Http\Request;

class RecoverPasswordController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function recoverpassword(Request $request)
    {
        if(isset($request->email))
        {
            $email = $request->email;
            // Verificamos que el email existe
            if($this->_checkEmail($email))
            {
                // Ahora creamos el codigo de confirmacion
                $confirmation_code = rand(100000, 999999);
                // Guardamos ese codigo en su usuario
                User::where('status', 'A')->where('email', $email)
                ->update(array(
                    'code'   => $confirmation_code
                ));
                // Obtenemos el nombre completo
                $forPerson = User::where('status', 'A')->where('email', $email)->get()->first();
                // Obtenemos la informacion de la persona
                $person = Person::where('status', 'A')->where('id', $forPerson->person_id)->get()->first();
                // Nombre completo
                $fullname = $person->first_name . ' ' . $person->last_name;
                // Generamos el codigo
                $sid = base64_encode($forPerson->sid);
                // Ya tenemos guardado el codigo en el usuario
                // Ahora debemos enviar el codigo de confirmacion al correo
                SendCodeForRecoverAccount::dispatch($fullname, $email, $confirmation_code, $sid);
                return response()->json(
                    [
                        'status'    =>  'success',
                        'message'   =>  'Email sended'
                    ], 200
                );
            }
            else
            {
                return response()->json(
                    [
                        'status'    =>  'fail',
                        'message'   =>  'Invalid email'
                    ], 500
                );
            }
        }
        else
        {
            return response()->json(
                [
                    'status'    =>  'fail',
                    'message'   =>  'Invalid email'
                ], 500
            );
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updatetheuserdata(Request $request)
    {
        $sid = $request->sid;
        $codeReceived = $request->code;
        $password = $request->password;
        $encrypted = $request->encrypted;
        if(User::where('status', 'A')->where('sid', $sid)->where('code', $codeReceived)->exists())
        {
            User::where('sid', $sid)->where('status', 'A')
                ->update(
                    array(
                        'code'      =>  null,
                        'password'  =>  bcrypt($password)
                    )
                );
            UsersPasswords::where('users_id', $request->sid)->update(
                array(
                    'password'      => $encrypted,
                    'updated_at'    => date("Y-m-d H:i:s")
                )
            );
            return response()->json(
                [
                    'status'    =>  'success'
                ], 200
            );
        }
        else
        {
            return response()->json(
                [
                    'status'    =>  'fail'
                ], 409
            );
        }
    }

    /**
     * Check if the email exists in the user table
     * @param $email
     * @return bool
     */
    private function _checkEmail($email)
    {
        return (User::where('email', $email)->exists()) ? true : false;
    }
}
