<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;

class ProfileController extends Controller
{
    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function getmyprofile()
    {
        $response = User::select('profile_picture', 'email', 'person_id')->where('sid', $this->_getusersid())
            ->where('status', 'A')
            ->with(['person'])
            ->get()->first();
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateprofilepicture(Request $request)
    {
        $response = User::where('sid', $this->_getusersid())->where('status', 'A')
            ->update(array(
                'profile_picture'   =>  $request->profile_picture
            ));
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @return mixed
     */
    private function _getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }
}
