<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Person;
use Illuminate\Support\Facades\DB;

class PersonController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getpersonbypage(Request $request)
    {
        $response = Person::where('status', 'A')
        ->where('id', '>', 1)
        ->with(
            [
                'cargo', 'area',
            ]
        )->orderBy('created_at', 'DESC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallperson()
    {
        // Obtenemos las personas
        $response = Person::where('status','A')->where('id', '>', 1)->get();
        // Retornamos la respuesta
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getpersonbyid(Request $request)
    {
        $response = Person::where('status', 'A')->where('id', $request->id)->get()->first();
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function registerperson(Request $request)
    {
        $users_sid = $this->_getusersid();
        $request->merge(['users_sid' => $users_sid]);
        $response = Person::create($request->all());
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateperson(Request $request)
    {
        $users_sid = $this->_getusersid();
        $request->merge(['users_sid' => $users_sid]);
        $response = Person::where('id', $request->id)->update($request->all());
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function deleteperson(Request $request)
    {
        $response = Person::where('id', $request->id)->update(['status' => 'X']);
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchpersonbypage(Request $request)
    {
        $response = Person::where('status', 'A')
                          ->where(DB::raw("CONCAT(`first_name`, ' ', `last_name`)"), 'LIKE', '%'.$request->search.'%')
                          ->orWhere('phone_number', 'LIKE', '%'.$request->search.'%')
                          ->with(
                                [
                                    'cargo', 'area'
                                ]
                          )->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @return mixed
     */
    private function _getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }
}
