<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\RolPerm;

class PermController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallperm(Request $request)
    {
        $response = RolPerm::with(
            [
                'user','rol'
            ]
        )->orderBy('global_rol_id', 'ASC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getpermbyid(Request $request)
    {
        $response = RolPerm::where('id', $request->id)->get()->first();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchdata(Request $request)
    {
        $response = RolPerm::where('module_uri', 'like', '%'.$request->search.'%')
            ->orWhere('local_uri', 'like', '%'.$request->search.'%')
            ->with(
                [
                    'user','rol'
                ]
            )->orderBy('global_rol_id', 'ASC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function saveallperm(Request $request)
    {
        $users_sid = $this->getusersid();
        $request->merge(['users_sid' => $users_sid]);
        $response = RolPerm::create($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateallperm(Request $request)
    {
        $users_sid = $this->getusersid();
        $request->merge(['users_sid' => $users_sid]);
        $response = RolPerm::where('id', $request->id)->update($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function removeperm(Request $request)
    {
        $response = RolPerm::where('id', $request->id)->delete();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @return mixed
     */
    private function getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }
}
