<?php

namespace App\Http\Controllers;

use App\Models\BranchOffice;
use App\Models\LicenseServer;
use App\Models\System;
use Illuminate\Http\Request;
use Illuminate\Support\Env;
use Illuminate\Support\Facades\Artisan;

class LicenseServerController extends Controller
{

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updatelicenseserver(Request $request)
    {
        // Obtenemos la informacion
        $license    = $request->license;
        $exp        = $request->expiration_date;
        // Ahora actualizamos la informacion
        LicenseServer::where('status', 'A')->where('license', $license)
            ->update(array(
                'expiration_date'   =>  $exp
            ));
        // Ahora obtenemos la informacion de la licencia
        $licenseData = LicenseServer::where('status', 'A')->where('license', $license)->get()->first();
        // Ahora con esa informacion obtenemos el branch y actualizamos la fecha de expiracion
        BranchOffice::where('status', 'A')->where('license_server_id', $licenseData->id)
            ->update(array(
                'exp'   =>  $exp
            ));
        // Devolvemos un true
        return response()->json(
            [
                'status'        =>      'success',
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function savenewlicenselocal(Request $request)
    {
        $request->merge(['users_sid' => $this->getusersid()]);
        $response = LicenseServer::create($request->all());
        return response()->json(
            [
                'status'        =>      'success',
                'response'      =>      $response
            ], 200
        );
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function getallserialnumbers()
    {
        // Limpiamos la cache
        Artisan::call('cache:clear');
        Artisan::call('config:clear');
        $phpOS = PHP_OS;
        $hostname = gethostname();
        if($phpOS == "WINNT")
        {
            if(Env::getRepository()->has('SERIALNUMBER'))
            {
                if(env('SERIALNUMBER')=="")
                {
                    $serialNumber       = $this->_cleandata(shell_exec('wmic diskdrive get serialnumber'));
                    $biosSerialNumber   = $this->_cleandata(shell_exec('wmic bios get serialnumber'));
                    $volSerialNumber    = $this->_cleanvol(shell_exec('vol'));
                    $this->putPermanentEnv('SERIALNUMBER', $serialNumber, $phpOS);
                    $this->putPermanentEnv('BIOSSERIALNUMBER', $biosSerialNumber, $phpOS);
                    $this->putPermanentEnv('VOLSERIALNUMBER', $volSerialNumber, $phpOS);
                }
                else
                {
                    $serialNumber       = env('SERIALNUMBER');
                    $biosSerialNumber   = env('BIOSSERIALNUMBER');
                    $volSerialNumber    = env('VOLSERIALNUMBER');
                }
            }
            else
            {
                return response()->json(
                    [
                        'status'            =>      'fail',
                    ], 409
                );
            }
        }
        else
        {
//            $serialNumber       =   strtoupper(md5(gethostname().PHP_OS));
//            $biosSerialNumber   =   strtoupper(sha1(gethostname().PHP_OS));
//            $volSerialNumber    =   strtoupper(sha1(md5(gethostname().PHP_OS)));
            if(Env::getRepository()->has('SERIALNUMBER'))
            {
                if(env('SERIALNUMBER')=="")
                {
                    $biosSerialNumber   = strtoupper(str_replace("\n", "", str_replace("-", "", shell_exec('hostname'))));
                    $serialNumber       = strtoupper(str_replace("\n", "", str_replace("-", "", shell_exec('uuidgen --sha1 --namespace @dns --name "'.$biosSerialNumber.'"'))));
                    $volSerialNumber    = strtoupper(str_replace("\n", "", str_replace("-", "", shell_exec('whoami'))));
                    $this->putPermanentEnv('SERIALNUMBER', $serialNumber, $phpOS);
                    $this->putPermanentEnv('BIOSSERIALNUMBER', $biosSerialNumber, $phpOS);
                    $this->putPermanentEnv('VOLSERIALNUMBER', $volSerialNumber, $phpOS);
                }
                else
                {
                    $serialNumber       = env('SERIALNUMBER');
                    $biosSerialNumber   = env('BIOSSERIALNUMBER');
                    $volSerialNumber    = env('VOLSERIALNUMBER');
                }
            }
            else
            {
                return response()->json(
                    [
                        'status'            =>      'fail'
                    ], 409
                );
            }
        }
        // Ahora limpiamos la informacion
        #Artisan::call('config:clear');
        // Retornamos la informacion
        return response()->json(
            [
                'status'            =>      'success',
                'hostname'          =>      $hostname,
                'serialnumber'      =>      $serialNumber,
                'biosserialnumber'  =>      $biosSerialNumber,
                'volserialnumber'   =>      $volSerialNumber
            ], 200
        );
    }

    /**
     * @param $key
     * @param $value
     * @param $os
     */
    private function putPermanentEnv($key, $value, $os)
    {
        $path = app()->environmentFilePath();
        if($os == "WINNT")
        {
            env($key, $value);
            putenv($key.'='.$value);
        }
        else
        {
            $escaped = preg_quote('='.env($key), '/');
            file_put_contents($path, preg_replace(
                "/^{$key}{$escaped}/m",
                "{$key}={$value}",
                file_get_contents($path)
            ));
        }

    }

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallvalidlicense()
    {
        // Registramos los valores iniciales
        $today = date("Y-m-d");
        $branch = new BranchOffice();
        $globalSystemId = new System();
        // Verificamos las licencias
        if(LicenseServer::where('status', 'A')->where('expiration_date', '>=', $today)->exists())
        {
            $response = LicenseServer::where('status', 'A')
                ->where('expiration_date', '>=', $today)
                ->whereNotIn('id', function($q)use($branch, $globalSystemId, $today){
                    $q->select('license_server_id')->from($branch->getTableName())
                        ->whereIn('global_system_id', function($q)use($globalSystemId, $today) {
                            $q->select('id')->from($globalSystemId->getTableName())
                                ->where('status', 'A')->where('exp', '>=', $today);
                        })
                        ->where('status', 'A');
                })
                ->get();
            return response()->json(
                [
                    'status'        =>      'success',
                    'message'       =>      $response
                ], 200
            );
        } else {
            return response()->json(
                [
                    'status'        =>      'fail',
                    'message'       =>      'No license server founded'
                ], 409
            );
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function ping(Request $request)
    {
        $phpOS = PHP_OS;
        if($phpOS == "WINNT")
        {
            exec("ping -n 1 " . $request->host, $out, $status);
        }
        else
        {
            return response()->json(
                [
                    'status'    =>      'conflict',
                    'message'   =>      'No podemos confirmar o negar',
                ], 400
            );
        }
        if(0 == $status)
        {
            return response()->json(
                [
                    'status'    =>      'success',
                    'message'   =>      'En vida!',
                    'out'       =>      $out
                ], 200
            );
        }
        else
        {
            return response()->json(
                [
                    'status'    =>      'fail',
                    'message'   =>      'Fuera de linea!',
                    'out'       =>      $out
                ], 400
            );
        }
    }

    /**
     * @param $data
     * @return string|string[]
     */
    private function _cleandata($data)
    {
        return str_replace("\n", "", str_replace("\r\n", "", str_replace(" ", "", str_replace("SerialNumber", "", str_replace(".", "", $data)))));
    }

    /**
     * @param $data
     * @return mixed
     */
    private function _cleanvol($data)
    {
        $data = str_replace("\n", "", $data);
        if(isset(explode(" is ", str_replace("\n", "", $data))[2]))
        {
            return trim(explode(" is ", str_replace("\n", "", $data))[2]);
        }
        elseif(isset(explode(" es:", $data)[1]))
        {
			return trim(explode(" es:", $data)[1]);
        }
		else
		{
			return trim(explode(" is ", str_replace("\n", "", $data))[1]);
		}
    }

    /**
     * @return string
     * @throws \Exception
     */
    private function randomchar()
    {
        return strtoupper(bin2hex(random_bytes(12)));
    }

    /**
     * @return mixed
     */
    private function getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }

}
