<?php

namespace App\Http\Controllers;

use App\Models\Holiday;
use Illuminate\Http\Request;

class HolidayController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallholiday(Request $request)
    {
        $response = Holiday::where('status', 'A')
            ->orderBy('created_at', 'DESC')->get();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getholidaybypage(Request $request)
    {
        $response = Holiday::where('status', 'A')
            ->with(['user'])
            ->orderBy('created_at', 'DESC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getholidaybyid(Request $request)
    {
        $response = Holiday::where('status', 'A')
            ->with(['user'])
            ->where('id', $request->id)
            ->orderBy('created_at', 'DESC')->get()->first();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function registerholiday(Request $request)
    {
        $request->merge(['users_sid' => $this->getusersid()]);
        $response = Holiday::create($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateholiday(Request $request)
    {
        $request->merge(['users_sid' => $this->getusersid()]);
        $response = Holiday::where('id', $request->id)->update($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function deleteholiday(Request $request)
    {
        $response = Holiday::where('id', $request->id)->update(array('status', 'X'));
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchdataholiday(Request $request)
    {
        $response = Holiday::where('holiday_name', 'like', '%'.$request->search.'%')
            ->with(['user'])
            ->orderBy('id', 'DESC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchdataholidaybydate(Request $request)
    {
        $response = Holiday::where('holiday_date', $request->search)
            ->with(['user'])
            ->orderBy('id', 'DESC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @return mixed
     */
    private function getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }
}
