<?php

namespace App\Http\Controllers;

use App\Models\History;
use App\Models\LicenseServer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;

class HistoryController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function checktoday(Request $request)
    {
        $today = date("Y-m-d");
        $ctoday = sha1($request->pass.$today);
        // Obtenemos la licencia
        if(LicenseServer::where('status', 'A')->exists())
        {
            $licenseData = LicenseServer::where('status', 'A')
                ->where('expiration_date', '>=', date("Y-m-d"))
                ->orderBy('created_at', 'DESC')->get();
        }
        else
        {
            return response()->json(
                [
                    'status' => 'fail'
                ], 409
            );
        }
        // Para almacenar las licencias
        $licenses = array();
        // Todas las licencias encontradas
        foreach ($licenseData as $license)
        {
            $licenses[] = $license['license'];
        }
        $licenseJoined = join("|", $licenses);
        // Recorremos todas las licencias registradas
        foreach ($licenseData as $license)
        {
            // Verificamos la condicion
            if(!History::where('ss', $license['license'])->where('sss', $ctoday)->exists())
            {
                // Limpiamos la cache
                Artisan::call('cache:clear');
                Artisan::call('config:clear');
                $hostname = gethostname();
                $phpOS = PHP_OS;
                if($phpOS == "WINNT")
                {
                    $serialNumber       = $this->_cleandata(shell_exec('wmic diskdrive get serialnumber'));
                    $biosSerialNumber   = $this->_cleandata(shell_exec('wmic bios get serialnumber'));
                    $volSerialNumber    = trim(str_replace("\n", "", $this->_cleanvol(shell_exec('vol'))));
                }
                else
                {
//                    $serialNumber       =   strtoupper(md5(gethostname().PHP_OS));
//                    $biosSerialNumber   =   strtoupper(sha1(gethostname().PHP_OS));
//                    $volSerialNumber    =   strtoupper(sha1(md5(gethostname().PHP_OS)));
                    $biosSerialNumber   = strtoupper(str_replace("\n", "", str_replace("-", "", shell_exec('hostname'))));
                    $serialNumber       = strtoupper(str_replace("\n", "", str_replace("-", "", shell_exec('uuidgen --sha1 --namespace @dns --name "'.$biosSerialNumber.'"'))));
                    $volSerialNumber    = strtoupper(str_replace("\n", "", str_replace("-", "", shell_exec('whoami'))));
                }
                // Return the important data
                return response()->json(
                    [
                        'status'            =>      'success',
                        'hostname'          =>      $hostname,
                        'serialnumber'      =>      $serialNumber,
                        'biosserialnumber'  =>      $biosSerialNumber,
                        'volserialnumber'   =>      $volSerialNumber,
                        'license'           =>      $licenseJoined,
                        'licenseError'      =>      $license['license']
                    ], 200
                );
            }
        }
        return response()->json(
            [
                'status'    =>  'verified',
                'lv'        =>  $licenses
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function savetodaycheck(Request $request)
    {
        $today              = date("Y-m-d");
        $ctoday             = sha1($request->pass.$today);
        $license            = explode("|", $request->license);
        $cuantasLicencias   = count($license);
        // Verificamos la cantidad de licencias
        if($cuantasLicencias == 1)
        {
            // Guardamos el registro
            History::create(
                array(
                    'ss'     =>  $request->license,
                    'sss'    =>  $ctoday
                )
            );
        }
        else
        {
            foreach ($license as $licencias)
            {
                // Guardamos el registro
                History::create(
                    array(
                        'ss'     =>  $licencias,
                        'sss'    =>  $ctoday
                    )
                );
            }
        }
        // Devolvemos correcto
        return response()->json(
            [
                'status'            =>      'success'
            ], 200
        );
    }

    /**
     * @param $key
     * @param $value
     */
    private function putPermanentEnv($key, $value)
    {
        $path = app()->environmentFilePath();

        $escaped = preg_quote('='.env($key), '/');

        file_put_contents($path, preg_replace(
            "/^{$key}{$escaped}/m",
            "{$key}={$value}",
            file_get_contents($path)
        ));
    }

    /**
     * @param $data
     * @return string|string[]
     */
    private function _cleandata($data)
    {
        return str_replace("\n", "", str_replace("\r\n", "", str_replace(" ", "", str_replace("SerialNumber", "", str_replace(".", "", $data)))));
    }

    /**
     * @param $data
     * @return mixed
     */
    private function _cleanvol($data)
    {
        if(isset(explode(" is ", str_replace("\n", "", $data))[2]))
        {
            return explode(" is ", str_replace("\n", "", $data))[2];
        }
        elseif(isset(explode(" es:", $data)[1]))
        {
            return explode(" es:", $data)[1];
        }
        else
        {
            return explode(" is ", str_replace("\n", "", $data))[1];
        }
    }
}
