<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Dosage;

class DosageController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getalldosage(Request $request)
    {
        $response = Dosage::where('status', 'A')
            ->with(['user', 'branch'])
            ->orderBy('created_at', 'DESC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getdosagebyid(Request $request)
    {
        $response = Dosage::where('status', 'A')->where('id', $request->id)
            ->with(['user', 'branch'])
            ->orderBy('created_at', 'DESC')->get()->first();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function register(Request $request)
    {
        $request->merge(['users_sid' => $this->getusersid()]);
        $response = Dosage::create($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request)
    {
        $request->merge(['users_sid' => $this->getusersid()]);
        $response = Dosage::where('id', $request->id)->update($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function delete(Request $request)
    {
        $response = Dosage::where('id', $request->id)->update(array('status', 'X'));
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchdata(Request $request)
    {
        $response = Dosage::where('autorizacion', 'like', '%'.$request->search.'%')
            ->orWhere('rubro', 'like', '%'.$request->search.'%')
            ->orWhere('leyenda', 'like', '%'.$request->search.'%')
            ->with(['user', 'branch'])
            ->orderBy('id', 'ASC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @return mixed
     */
    private function getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }
}
