<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Currency;

class CurrencyController extends Controller
{

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function getjustcurrency()
    {
        $response = Currency::where('status', 'A')->where('usd_dollar', 'N')->get();
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallcurrency(Request $request)
    {
        $response = Currency::where('status', 'A')
            ->with(['user', 'country'])
            ->orderBy('created_at', 'ASC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getcurrencybyid(Request $request)
    {
        $response = Currency::where('status', 'A')
            ->with(['user', 'country'])
            ->where('id', $request->id)
            ->orderBy('created_at', 'DESC')->get()->first();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function register(Request $request)
    {
        $request->merge(['users_sid' => $this->getusersid()]);
        $response = Currency::create($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request)
    {
        $request->merge(['users_sid' => $this->getusersid()]);
        $response = Currency::where('id', $request->id)->update($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function delete(Request $request)
    {
        $response = Currency::where('id', $request->id)->update(array('status', 'X'));
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchdata(Request $request)
    {
        $response = Currency::where('currency', 'like', '%'.$request->search.'%')
            ->orWhere('code', 'like', '%'.$request->search.'%')
            ->with(['user', 'country'])
            ->orderBy('id', 'ASC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @return mixed
     */
    private function getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }
}
