<?php

namespace App\Http\Controllers;

use App\Models\Countries;
use Carbon\Carbon;

class CountriesController extends Controller
{

    const COUNTRY_CACHE = 'COUNTRY';

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallcountries()
    {
        $response = Countries::orderBy('name', 'ASC')->get();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function getcountries()
    {
        $key = "countries.get";
        $cacheKey = $this->getCacheKey($key);
        $response = cache()->remember($cacheKey, Carbon::now()->addDays(30), function () {
            return Countries::orderBy('name', 'ASC')->get();
        });
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param $key
     * @return string
     */
    private function getCacheKey($key)
    {
        $key = strtoupper($key);
        return self::COUNTRY_CACHE . ".$key";
    }

}
