<?php

namespace App\Http\Controllers;

use App\Models\Configuration;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ConfigurationController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getconfiguration()
    {
        $response = Configuration::where('status', 'A')
            ->with(['user', 'area','cargo'])
            ->orderBy('created_at', 'DESC')->get()->first();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getconfigurationbyid(Request $request)
    {
        $response = Configuration::where('status', 'A')
            ->where('relative', $request->relative)
            ->with(['user', 'area','cargo'])
            ->orderBy('created_at', 'DESC')->get()->first();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function registerconfiguration(Request $request)
    {
        $request->merge(
            [
                'relative'                  =>  Str::uuid()->toString(),
                'users_sid'                 =>  $this->getusersid(),
                'created_at'                =>  date("Y-m-d H:i:s")
            ]
        );
        $response = Configuration::create($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateconfiguration(Request $request)
    {
        $request->merge(
            [
                'users_sid'                 =>  $this->getusersid(),
                'updated_at'                =>  date("Y-m-d H:i:s")
            ]
        );
        $response = Configuration::where('relative', $request->relative)->update($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function logicaldeleteconfiguration(Request $request)
    {
        $response = Configuration::where('relative', $request->relative)
            ->update(array('status' => 'X'));
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function deleteconfiguration(Request $request)
    {
        $response = Configuration::where('relative', $request->relative)->delete();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchdataconfiguration(Request $request)
    {
        $response = Configuration::where('status', 'A')
            ->where('enable_login', 'LIKE', '%'.$request->search.'%')
            ->with(['user', 'area','cargo'])
            ->orderBy('created_at', 'DESC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function gettheinitialconfigutarion()
    {
        $response = Configuration::where('status', 'A')->get()->first();
        if(isset($response)){
            $enable_register = $response->enable_register;
        } else {
            $enable_register = "N";
        }
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $enable_register
            ], 200
        );
    }

    /**
     * @return mixed
     */
    private function getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }
}
