<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Catalogs;

class CatalogsItemsController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAll(Request $request)
    {
        $response = Catalogs::where('status', 'A')
            ->with(['users'])
            ->where('catalog_code', $request->catalog_code)
            ->where('catalog_code_dep', '0')
            ->where('catalog_id_dep', '0')
            ->orderBy('label', 'ASC')
            ->get();
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAllArray(Request $request)
    {
        $response = array();
        foreach ($request->catalogs as $data) {
            $forvariable = strtolower($data);
            ${$forvariable} = Catalogs::where('status', 'A')
                ->with(['users'])
                ->where('catalog_code', $data)
                ->orderBy('created_at', 'DESC')
                ->get();
            $response[] = ${$forvariable};
        }
        $response[] = array(['status' => 'success']);
        return response()->json($response, 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getById(Request $request)
    {
        $response = Catalogs::where('status', 'A')
            ->where('id', $request->id)
            ->where('catalog_code', $request->catalog_code)
            ->with(['users'])
            ->get();
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getByUserId(Request $request)
    {
        $response = Catalogs::where('status', 'A')
            ->where('users_sid', $request->users_sid)
            ->where('catalog_code', $request->catalog_code)
            ->with(['users'])
            ->get();
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getByMyOwnUserId(Request $request)
    {
        $userid = $this->getusersid();
        $response = Catalogs::where('status', 'A')
            ->where('users_sid', $userid)
            ->where('catalog_code', $request->catalog_code)
            ->with(['users'])
            ->get();
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallbypage(Request $request)
    {
        $response = Catalogs::where('status', 'A')
            ->where('catalog_code', $request->catalog_code)
            ->where('catalog_code_dep', '0')
            ->where('catalog_id_dep', '0')
            ->with(['users'])
            ->orderBy('created_at', 'DESC')
            ->paginate($request->pagination);
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function saveData(Request $request)
    {
        $users_sid = $this->getusersid();
        $request->merge(['users_sid'=>$users_sid]);
        $max = Catalogs::where('catalog_code', $request->catalog_code)
            ->where('status', 'A')
            ->max('value');
        $max = $max + 1;
        $request->merge(['value' => $max]);
        $response = Catalogs::create($request->all());
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateData(Request $request)
    {
        $users_sid = $this->getusersid();
        $request->merge(['users_sid'=>$users_sid]);
        $response = Catalogs::where('id', $request->id)
            ->where('catalog_code', $request->catalog_code)
            ->update($request->all());
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function deleteData(Request $request)
    {
        $response = Catalogs::where('value', $request->id)
            ->where('catalog_code', $request->catalog_code)
            ->update(array('status' => 'X'));
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function removeData(Request $request)
    {
        $response = Catalogs::where('value', $request->id)
            ->where('catalog_code', $request->catalog_code)
            ->delete();
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchData(Request $request)
    {
        $response = Catalogs::where('label', 'like', '%'.$request->search.'%')
            ->where('status', 'A')
            ->where('catalog_code', $request->catalog_code)
            ->where('catalog_code_dep', '0')
            ->where('catalog_id_dep', '0')
            ->with(['users'])
            ->orderBy('created_at', 'DESC')
            ->paginate($request->pagination);
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getsubcategorybyid(Request $request)
    {
        $data = Catalogs::where([
            'catalog_code_dep'      =>      strtoupper($request->catalog_code),
            'catalog_code'          =>      strtoupper($request->catalog_code),
            'catalog_id_dep'        =>      $request->id,
            'value'                 =>      $request->ownid,
            'status'                =>      'A'
        ])->first();
        if($data)
        {
            return response()->json([
                'status'    =>  'success',
                'message'   =>  $data
            ], 200);
        }
        else
        {
            return response()->json([
                'status'    =>  'error',
                'message'   =>  'No data available'
            ], 200);
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function newsubcategory(Request $request)
    {
        // Get the user SID
        $users_sid = $this->getusersid();
        // Merge the user SID for save
        $request->merge(['users_sid' => $users_sid]);

        // Get the max id on value for the catalog
        $max = Catalogs::where('catalog_code', strtoupper($request->catalog_code))
            ->where('catalog_code_dep', strtoupper($request->catalog_code_dep))
            ->where('catalog_id_dep', $request->catalog_id_dep)
            ->where('status', 'A')
            ->max('value');
        $max = $max + 1;
        // Merge the value on max plus one
        $request->merge(['value' => $max]);

        // Register the complete data
        $request->request->remove('dependency');
        $response = Catalogs::create($request->all());

        return response()->json([
            'status'    =>  'success',
            'message'   =>  $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updatesubcategory(Request $request)
    {
        // Get the user SID
        $users_sid = $this->getusersid();
        // Merge the user SID for save
        $request->merge(['users_sid' => $users_sid]);

        $request->request->remove('dependency');
        $request->request->remove('id');

        // Update the information data
        $response = Catalogs::where([
            'catalog_code_dep'      =>      strtoupper($request->catalog_code_dep),
            'catalog_code'          =>      strtoupper($request->catalog_code),
            'catalog_id_dep'        =>      $request->catalog_id_dep,
            'value'                 =>      $request->value,
            'status'                =>      'A'
        ])->update($request->all());

        // @return
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getsubcategory(Request $request)
    {
        $thereis = Catalogs::where([
            'catalog_code'  => strtoupper($request->catalog_code),
            'lang'          => 'es',
            'status'        => 'A',
            'value'         => $request->value
        ])->first();
        if($thereis)
        {
            $getdata = Catalogs::where([
                'status'            =>  'A',
                'catalog_code_dep'  =>  strtoupper($request->catalog_code),
                'catalog_id_dep'    =>  $request->value
            ])->with([
                'parent' => function($q)use($request){
                    $q->where([
                        'catalog_code'      =>  strtoupper($request->catalog_code),
                        'value'             =>  strtoupper($request->value),
                        'catalog_code_dep'  =>  0,
                        'catalog_id_dep'    =>  0
                    ]);
                }
            ])
                ->orderBy('value', 'ASC')->paginate($request->pagination);
            return response()->json([
                'status'    => 'success',
                'message'   => $getdata
            ], 200);
        }
        else
        {
            return response()->json([
                'status'    => 'error',
                'message'   => 'no data available'
            ], 409);
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getcatalogdependency(Request $request)
    {
        $getdata = Catalogs::where([
            'status'            =>  'A',
            'catalog_code'      => strtoupper($request->catalog_code),
            'value'             =>  $request->value
        ])->first();
        return response()->json([
            'status'    => 'success',
            'message'   => $getdata
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getCatalogSearch(Request $request)
    {
        $response = Catalogs::where('label', 'like', '%'.$request->search.'%')
            ->where('catalog_code', $request->catalog_code)
            ->orderBy('value', 'ASC')
            ->paginate($request->pagination);
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getSubCategoryByCategoryCode(Request $request)
    {
        $response = Catalogs::where('catalog_code_dep', $request->catalog_code)
            ->where('catalog_id_dep', $request->catalog_id_dep)
            ->where('status', 'A')
            ->orderBy('label', 'ASC')
            ->get();
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function deletesubcategorycatalog(Request $request)
    {
        $response = Catalogs::where('catalog_code', $request->catalog_code)
            ->where('id', $request->id)
            ->where('value', $request->value)
            ->delete();
        return response()->json([
            'status' => 'success',
            'message' => $response
        ], 200);
    }

    /**
     * @return mixed
     */
    private function getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }

    /**
     * @param $folder
     */
    private function makefolder($folder)
    {
        $path = public_path().DIRECTORY_SEPARATOR.'storage'.DIRECTORY_SEPARATOR.$folder;
        File::makeDirectory($path, $mode=0777, true, true);
    }
}
