<?php

namespace App\Http\Controllers;

use App\Models\LicenseServer;
use App\Models\System;
use Illuminate\Http\Request;
use App\Models\BranchOffice;
use Illuminate\Support\Str;

class BranchController extends Controller
{

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function getjustbranch()
    {
        $response = BranchOffice::where('status', 'A')->get();
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function savebranch(Request $request)
    {
        $request->merge(['users_sid' => $this->getusersid(), 'relative' => Str::uuid()->toString()]);
        $response = BranchOffice::create($request->all());
        // Update the system because the license
        System::where('id', $request->global_system_id)->update(
            array(
                'status'    =>  'X',
                'exp'       =>  null
            )
        );
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallbranchbypage(Request $request)
    {
        // Obtenemos las sucursales disponibles
        $sucursales = BranchOffice::where('status', 'A')
            ->with(
                [
                    'user', 'system', 'license', 'countries', 'cities'
                ]
            )
            ->orderBy('global_system_id', 'ASC')->paginate($request->pagination);
        // Retornamos informacion de las sucursales
        return response()->json(
            [
                'status'    =>  'success',
                'message'   =>  $sucursales
            ], 200
        );
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallbranch()
    {
        if($this->_isthereabranch())
        {
            $response = BranchOffice::where('status', 'A')
                ->with(
                    [
                        'user', 'system', 'license', 'countries', 'cities'
                    ]
                )->get();
            return response()->json(
                [
                    'status'    =>  'success',
                    'message'   =>  $response
                ], 200
            );
        }
        else
        {
            return response()->json(
                [
                    'status'    =>  'fail',
                    'message'   =>  'We cannot find any branch available'
                ], 200
            );
        }

    }

    /**
     * @return bool
     */
    private function _isthereabranch()
    {
        return (BranchOffice::where('status', 'A')->exists()) ? true : false;
    }

    /**
     * @return mixed
     */
    private function getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }
}
