<?php

namespace App\Http\Controllers;

use App\Models\Behavior;
use Illuminate\Http\Request;

class BehaviorController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getallbehavior(Request $request)
    {
        $response = Behavior::where('status', 'A')->with(['user'])
            ->orderBy('created_at', 'ASC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getbehaviorbyid(Request $request)
    {
        $response = Behavior::where('status', 'A')
            ->with(['user'])->where('id', $request->id)
            ->orderBy('created_at', 'DESC')->get()->first();
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function registerbehavior(Request $request)
    {
        $request->merge(['users_sid' => $this->getusersid()]);
        $response = Behavior::create($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updatebehavior(Request $request)
    {
        $request->merge(['users_sid' => $this->getusersid()]);
        $response = Behavior::where('id', $request->id)->update($request->all());
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function deletebehavior(Request $request)
    {
        $response = Behavior::where('id', $request->id)->update(array('status', 'X'));
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchdatabehavior(Request $request)
    {
        $response = Behavior::where('behavior', 'like', '%'.$request->search.'%')
            ->with(['user'])->orderBy('id', 'ASC')->paginate($request->pagination);
        return response()->json(
            [
                'status'    =>      'success',
                'message'   =>      $response
            ], 200
        );
    }

    /**
     * @return mixed
     */
    private function getusersid()
    {
        $user = response()->json(auth()->user());
        return $user->original->sid;
    }
}
